/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.logging;

import de.willuhn.logging.Level;
import de.willuhn.logging.Logger;
import de.willuhn.logging.Message;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;

public class JavaLoggingHandler
extends Handler {
    private static final Handler singleton = new JavaLoggingHandler();
    private static Map logMapping = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void publish(LogRecord record) {
        if (record == null) {
            return;
        }
        Level level = (Level)logMapping.get(record.getLevel());
        if (level == null) {
            level = Level.DEFAULT;
        }
        String message = record.getMessage();
        Throwable t = record.getThrown();
        if (t != null) {
            ByteArrayOutputStream bos = null;
            try {
                bos = new ByteArrayOutputStream();
                t.printStackTrace(new PrintStream(bos));
                message = message + "\n" + bos.toString();
            }
            finally {
                try {
                    bos.close();
                }
                catch (Exception exception) {}
            }
        }
        Message msg = new Message(new Date(record.getMillis()), level, null, record.getSourceClassName(), record.getSourceMethodName(), message, Thread.currentThread().getName());
        Logger.write(msg);
    }

    @Override
    public void close() throws SecurityException {
    }

    @Override
    public void flush() {
    }

    static {
        try {
            logMapping.put(java.util.logging.Level.CONFIG, Level.INFO);
            logMapping.put(java.util.logging.Level.FINE, Level.DEBUG);
            logMapping.put(java.util.logging.Level.FINER, Level.DEBUG);
            logMapping.put(java.util.logging.Level.FINEST, Level.TRACE);
            logMapping.put(java.util.logging.Level.INFO, Level.INFO);
            logMapping.put(java.util.logging.Level.SEVERE, Level.ERROR);
            logMapping.put(java.util.logging.Level.WARNING, Level.WARN);
            java.util.logging.Logger logger = java.util.logging.Logger.getLogger("");
            Handler[] handlers = logger.getHandlers();
            if (handlers != null) {
                for (int i = 0; i < handlers.length; ++i) {
                    handlers[i].setLevel(java.util.logging.Level.OFF);
                }
            }
            LogManager lm = LogManager.getLogManager();
            java.util.logging.Logger root = lm.getLogger("");
            root.addHandler(singleton);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

